/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/***
 * \file : led_test.c
 *
 * \brief: Source file for LED test.
 *
 * \b \Descr: This file contain the LED initialization function and LED handler
 * \n         function to test the LED blink test.
 *
 *
 */

#include "led.h"
#include "dm8127_types.h"
#include "gpio.h"
#include "dm8127_evm.h"
#include "dm8127_platform.h"

/***
 * \brief: LED initialization function.
 *
 * \b \Descr: This routine initialize pin functionality of LED blink test.
 *
 * \param:  VOID
 * \return: VOID
 */
void LED_init
(
	void
)
{
	UINT32 regval;
#if 0
	regval = LED_PIN_MUX();
#endif
	/* Reset GPIO1 Subsystem */
	GPIO1_SYSCONFIG = 0x0000002; /* Software Reset */
	delay(0x90000);
	GPIO1_SYSCONFIG = 0x08; /* no-idle */

	/* Output Enable GPIO16 in Bank 1 */
	regval = GPIO1_OE;
	regval = regval & ~(1 << LED_NUM_GP1_16);
	GPIO1_OE = regval;

	/* Output Enable GPIO30 in Bank 1 */
	regval = GPIO1_OE;
	regval = regval & ~(1 << LED_NUM_GP1_30);
	GPIO1_OE = regval;

	/* Output Enable GPIO0 in Bank 1 */
	regval = GPIO1_OE;
	regval = regval & ~(1 << LED_NUM_GP1_0);
	GPIO1_OE = regval;

	/* Output Enable GPIO7 in Bank 1 */
		regval = GPIO1_OE;
		regval = regval & ~(1 << LED_NUM_GP1_7);
		GPIO1_OE = regval;

	/* Reset GPIO0 Subsystem */
	GPIO0_SYSCONFIG = 0x00000002; /* Software Reset */
	delay(0x90000);
	GPIO0_SYSCONFIG = 0x008; /* no-idle */
#if 1
	/* Output Enable GPIO8 in Bank 0 */
	regval = GPIO0_OE;
	regval = regval & ~(1 << LED_NUM_GP0_8);
	GPIO0_OE = regval;
#endif
}

/***
 * \brief: LED switch ON routine.
 *
 * \b \Descr: This is the switching function for the LED from OFF
 *            state to ON state.
 *
 * \param:  LED_num  LED number
 * \n       bank     BAnk number (GPIO bank)
 *
 *\return: VOID
 */
void LED_on
(
	UINT16 LED_num,
	UINT16 bank
)
{
	if(GPIO_BANK_0 == bank)
	{
		GPIO0_SETDATAOUT = (1 << LED_num);
	}

	if(GPIO_BANK_1 == bank)
	{
		GPIO1_SETDATAOUT = (1 << LED_num);
	}

	if(GPIO_BANK_3 == bank)
	{
		GPIO3_SETDATAOUT = (1 << LED_num);
	}
}

/***
 * \brief: LED switch OFF routine.
 *
 * \b \descr: This is the switching function for the LED from ON
 * \n         state to OFF state.
 *
 * \param:  LED_num  LED number
 * \n       bank     BAnk number (GPIO bank)
 *
 * \return: VOID
 */

void LED_off
(
	UINT16 LED_num,
	UINT16 bank
)
{

	if(GPIO_BANK_0 == bank)
	{
		GPIO0_CLEARDATAOUT = (1 << LED_num);
	}

	if(GPIO_BANK_1 == bank)
	{
		GPIO1_CLEARDATAOUT = (1 << LED_num);
	}

	if(GPIO_BANK_3 == bank)
	{
		GPIO3_CLEARDATAOUT = (1 << LED_num);
	}
}

/***
 * \brief: LED status handler function.
 *
 * \descr: This is the switching function for the LED from ON
 *         state to OFF state and from the OFF state to on function.
 *
 * \param:  VOID
 *
 * \return: Always SUCCESS
 */
STATUS led_test
(
	void *testargs
)
{  
	UINT32 i;
	 Uart_stringSend("\r\n==================================="
					 "\r\n            LED Test               "
					 "\r\n===================================\r\n");
	Uart_stringSend("\r\n LED step and blinking test performing \r\n");
    /* Initialize the LED module */
    LED_init( );

  	LED_on(LED_NUM_GP1_30, GPIO_BANK_1);  //LED1
	delay( LED_DELAY );

    LED_on(LED_NUM_GP1_16, GPIO_BANK_1);  //LED2
    delay( LED_DELAY );

    LED_on(LED_NUM_GP0_8, GPIO_BANK_0);   //LED3
    delay( LED_DELAY );

    LED_on(LED_NUM_GP1_0, GPIO_BANK_1);   //LED5
    delay( LED_DELAY );

    LED_off(LED_NUM_GP1_7, GPIO_BANK_1);   //LED5
    		delay( LED_DELAY );
    LED_on(LED_NUM_GP1_7, GPIO_BANK_1);   //LED5
	delay( LED_DELAY );
#if 0
	LED_off(10, GPIO_BANK_1);   //LED5
					delay( LED_DELAY );

	LED_on(10, GPIO_BANK_1);   //LED5
				delay( LED_DELAY );
#endif
    delay( LED_DELAY );
    delay( LED_DELAY );

	LED_off(LED_NUM_GP1_30, GPIO_BANK_1);  //LED1
	delay( LED_DELAY );
	LED_off(LED_NUM_GP1_16, GPIO_BANK_1);  //LED2
	delay( LED_DELAY );
	LED_off(LED_NUM_GP0_8, GPIO_BANK_0);   //LED3
	delay( LED_DELAY );
	LED_off(LED_NUM_GP1_0, GPIO_BANK_1);   //LED4
	delay( LED_DELAY );
	LED_off(LED_NUM_GP1_7, GPIO_BANK_1);   //LED5
		delay( LED_DELAY );

	for ( i = 0 ; i < 5 ; i++ )
	{
		LED_on(LED_NUM_GP1_30, GPIO_BANK_1);  //LED1
		LED_on(LED_NUM_GP1_16, GPIO_BANK_1);  //LED2
		LED_on(LED_NUM_GP0_8, GPIO_BANK_0);   //LED3
		LED_on(LED_NUM_GP1_0, GPIO_BANK_1);   //LED4
		LED_on(LED_NUM_GP1_7, GPIO_BANK_1);   //LED5
		delay( LED_DELAY );

		LED_off(LED_NUM_GP1_30, GPIO_BANK_1);  //LED1
		LED_off(LED_NUM_GP1_16, GPIO_BANK_1);  //LED2
		LED_off(LED_NUM_GP0_8, GPIO_BANK_0);   //LED3
		LED_off(LED_NUM_GP1_0, GPIO_BANK_1);   //LED4
		LED_off(LED_NUM_GP1_7, GPIO_BANK_1);   //LED5
		delay( LED_DELAY );
	}
	Uart_stringSend("\r\n-------------------------X-----------------------------");
    return 0;
}
